import { NextResponse } from 'next/server';
import fs from 'fs/promises';
import path from 'path';

const adminsFilePath = path.join(process.cwd(), 'data', 'admins.json');

async function getAdmins() {
  try {
    const data = await fs.readFile(adminsFilePath, 'utf-8');
    return JSON.parse(data);
  } catch (error) {
    return [];
  }
}

async function saveAdmins(admins: any) {
  await fs.writeFile(adminsFilePath, JSON.stringify(admins, null, 2));
}

export async function GET() {
  const admins = await getAdmins();
  return NextResponse.json(admins);
}

export async function POST(request: Request) {
  const { userId } = await request.json();
  if (!userId) {
    return NextResponse.json({ error: 'Missing userId' }, { status: 400 });
  }

  const admins = await getAdmins();
  if (admins.find((admin: any) => admin.id === userId)) {
    return NextResponse.json({ error: 'Admin already exists' }, { status: 409 });
  }

  // You might want to fetch user info from Discord API here to store it
  const newUserInfo = { name: 'Nowy Admin', image: '' }; // Placeholder

  admins.push({ id: userId, userInfo: newUserInfo });
  await saveAdmins(admins);

  return NextResponse.json({ success: true });
}

export async function DELETE(request: Request) {
  const { userId } = await request.json();
  if (!userId) {
    return NextResponse.json({ error: 'Missing userId' }, { status: 400 });
  }

  let admins = await getAdmins();
  const initialLength = admins.length;
  admins = admins.filter((admin: any) => admin.id !== userId);

  if (admins.length === initialLength) {
    return NextResponse.json({ error: 'Admin not found' }, { status: 404 });
  }

  await saveAdmins(admins);

  return NextResponse.json({ success: true });
}
