import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";
import Providers from "./providers";
import { Toaster } from "sonner";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "RedCity RP",
  description: "Twoje miasto, Twoja historia, Twoje zasady.",
};

export const viewport = {
  width: "device-width",
  initialScale: 1,
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="pl">
      <body className={inter.className}>
        <Providers>
          <div className="flex flex-col min-h-screen">
            <main className="flex-grow">{children}</main>
            <footer className="bg-background border-t py-4 text-center text-muted-foreground text-sm">
              <p>&copy; {new Date().getFullYear()} RedCity RP. All rights reserved.</p>
            </footer>
          </div>
          <Toaster position="bottom-right" duration={3000} />
        </Providers>
      </body>
    </html>
  );
}
