"use client";
import { signIn } from "next-auth/react";
import Link from "next/link";
import Image from "next/image";
import { FaDiscord } from "react-icons/fa";
import { FiArrowLeft } from "react-icons/fi";
import { Button } from "@/components/ui/button";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";

export default function LoginPage() {
  return (
    <div className="relative min-h-screen flex items-center justify-center p-4 overflow-hidden">
      <Image
        src="/images/background.png"
        alt="Tło miasta"
        fill
        className="object-cover grayscale"
      />
      <div className="absolute inset-0 bg-black/50 z-10"></div>
      <div className="relative z-20 flex flex-col items-center animate-fade-in">
        <Card className="w-full max-w-md text-center">
          <CardHeader>
            <CardTitle className="text-4xl font-extrabold">
              Witaj w <span className="text-red-600">RedCity</span>
            </CardTitle>
            <CardDescription className="text-lg pt-2">
              Zaloguj się, aby uzyskać dostęp do swojego panelu gracza.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <Button
              onClick={() => signIn("discord", { callbackUrl: "/panel" })}
              className="w-full"
              size="lg"
            >
              <FaDiscord className="mr-2 h-6 w-6" />
              Zaloguj się z Discord
            </Button>
          </CardContent>
        </Card>
        <Button asChild variant="link" className="mt-8 text-white">
          <Link href="/" className="flex items-center space-x-2">
            <FiArrowLeft />
            <span>Powrót do strony głównej</span>
          </Link>
        </Button>
      </div>
    </div>
  );
}