"use client";

import { LineChart, Line, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer, BarChart, Bar } from 'recharts';

const websiteVisits = [
  { name: 'Pon', visits: 2400 },
  { name: 'Wt', visits: 1398 },
  { name: 'Śr', visits: 9800 },
  { name: 'Czw', visits: 3908 },
  { name: 'Pt', visits: 4800 },
  { name: 'Sob', visits: 3800 },
  { name: 'Ndz', visits: 4300 },
];

const newUsers = [
  { name: 'Sty', users: 400 },
  { name: 'Lut', users: 300 },
  { name: 'Mar', users: 200 },
  { name: 'Kwi', users: 278 },
  { name: 'Maj', users: 189 },
  { name: 'Cze', users: 239 },
  { name: 'Lip', users: 349 },
];

export default function Charts() {
  return (
    <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
      <div className="bg-card p-6 rounded-lg">
        <h3 className="text-lg font-semibold mb-4">Odwiedziny strony</h3>
        <ResponsiveContainer width="100%" height={300}>
          <LineChart data={websiteVisits}>
            <CartesianGrid strokeDasharray="3 3" />
            <XAxis dataKey="name" />
            <YAxis />
            <Tooltip />
            <Legend />
            <Line type="monotone" dataKey="visits" stroke="#8884d8" activeDot={{ r: 8 }} />
          </LineChart>
        </ResponsiveContainer>
      </div>
      <div className="bg-card p-6 rounded-lg">
        <h3 className="text-lg font-semibold mb-4">Nowi użytkownicy</h3>
        <ResponsiveContainer width="100%" height={300}>
          <BarChart data={newUsers}>
            <CartesianGrid strokeDasharray="3 3" />
            <XAxis dataKey="name" />
            <YAxis />
            <Tooltip />
            <Legend />
            <Bar dataKey="users" fill="#82ca9d" />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
}
