"use client";

import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";

const faqs = [
  {
    question: "Jak dołączyć do serwera?",
    answer: "Aby dołączyć do naszego serwera, musisz posiadać grę Grand Theft Auto V oraz aplikację FiveM. Następnie wyszukaj nasz serwer na liście serwerów FiveM lub połącz się bezpośrednio przez adres IP: redcity.rp.",
  },
  {
    question: "Czy serwer jest darmowy?",
    answer: "Tak, nasz serwer jest w pełni darmowy. Oferujemy jednak możliwość zakupu VPLN, które można przeznaczyć na dodatkowe przedmioty w grze.",
  },
  {
    question: "Jak mogę zostać członkiem frakcji?",
    answer: "Aby zostać członkiem frakcji, musisz przejść rekrutację. Informacje o rekrutacjach są regularnie publikowane na naszym Discordzie.",
  },
  {
    question: "Gdzie mogę zgłosić błąd lub problem?",
    answer: "Wszelkie błędy i problemy prosimy zgłaszać w zakładce Support w panelu gracza.",
  },
];

export default function Faq() {
  return (
    <section className="py-12 sm:py-16 lg:py-20">
      <div className="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <div className="text-center">
          <h2 className="text-3xl font-bold tracking-tight sm:text-4xl">Najczęściej zadawane pytania</h2>
          <p className="mt-4 text-lg text-muted-foreground">Nie możesz znaleźć odpowiedzi, której szukasz? Skontaktuj się z nami.</p>
        </div>
        <div className="mt-12">
          <Accordion type="single" collapsible className="w-full max-w-3xl mx-auto">
            {faqs.map((faq, index) => (
              <AccordionItem key={index} value={`item-${index}`}>
                <AccordionTrigger>{faq.question}</AccordionTrigger>
                <AccordionContent>{faq.answer}</AccordionContent>
              </AccordionItem>
            ))}
          </Accordion>
        </div>
      </div>
    </section>
  );
}
