import type { NextAuthOptions } from "next-auth";
import DiscordProvider from "next-auth/providers/discord"

export const authOptions: NextAuthOptions = {
  secret: process.env.NEXTAUTH_SECRET,
  providers: [
    DiscordProvider({
      clientId: process.env.DISCORD_CLIENT_ID as string,
      clientSecret: process.env.DISCORD_CLIENT_SECRET as string,
    }),
  ],
  callbacks: {
    async jwt({ token, account }) {
      if (account) {
        token.id = account.providerAccountId;
      }
      return token;
    },
    async session({ session, token }) {
      const adminIds = process.env.ADMIN_DISCORD_IDS?.split(',') || [];
      
      if (token.id && session.user) {
        const userId = token.id as string;
        (session.user as any).id = userId;
        (session.user as any).isAdmin = adminIds.includes(userId);
      }
      
      return session;
    },
  },
};
